<?php
// === Konfiguration ===
$archive_path = '/home/ravensb1/public_html/bilder'; // Lokaler Pfad
$archive_url  = 'https://ravensburg-webcam.de/bilder'; // URL zum Bild im Web
$picX         = 400; // Bildbreite

// === Bilder aus dem Verzeichnis lesen ===
$files = array_filter(scandir($archive_path), function($file) {
    return preg_match('/\.jpg$/i', $file);
});

rsort($files); // Neueste zuerst

// === HTML-Ausgabe ===
header("Content-Type: text/html; charset=utf-8");
?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Archivbilder ansehen</title>
  <style>
    body { font-family: Arial, sans-serif; background: #fff; color: #000; text-align: center; }
    select { font-size: 13px; font-family: Arial, Helvetica, sans-serif; }
    img { border: 1px solid #ccc; margin-top: 20px; }
  </style>
  <script>
    function changePic(url) {
      document.getElementById('image1').src = url;
    }
  </script>
</head>
<body>
  <h1>Archivbilder ansehen</h1>
  <?php if (!empty($files)): ?>
    <img id="image1" src="<?= $archive_url . '/' . $files[0] ?>" width="<?= $picX ?>" alt="Archivbild">
    <p>
      <form>
        <select name="list1" size="5" onchange="changePic(this.value)">
          <?php foreach ($files as $index => $file): 
            $datum = substr($file, 0, 4) . '-' . substr($file, 4, 2) . '-' . substr($file, 6, 2);
            $zeit  = substr($file, 9, 2) . ':' . substr($file, 11, 2);
            $label = "Datum: $datum&nbsp;&nbsp;Uhrzeit: $zeit";
          ?>
            <option value="<?= $archive_url . '/' . $file ?>" <?= $index === 0 ? 'selected' : '' ?>><?= $label ?></option>
          <?php endforeach; ?>
        </select>
      </form>
    </p>
  <?php else: ?>
    <p>Keine Bilder im Archiv gefunden.</p>
  <?php endif; ?>
  <p>
    <button onclick="window.close()">Fenster schließen</button>
  </p>
</body>
</html>
