<?php
// === Konfiguration ===
$webcam_url   = 'https://ravensburg-ipwebcam.de/webcam.jpg'; // Webcam-Bildquelle
$archive_path = '/home/ravensb1/public_html/bilder';          // Lokaler Speicherort
$archive_url  = 'https://ravensburg-webcam.de/bilder';        // URL zum Bild im Web
$max_images   = 100;                                          // Max. Anzahl gespeicherter Bilder
$image_width  = 400;                                          // Anzeigegröße im Browser

// === Zeitstempel für Dateinamen ===
$timestamp = date('Ymd_His');
$filename  = "$timestamp.jpg";
$filepath  = "$archive_path/$filename";

// === Bild abrufen und speichern ===
$image_data = @file_get_contents($webcam_url);

if ($image_data !== false) {
    file_put_contents($filepath, $image_data);
} else {
    $filename = 'offline.gif'; // Fallback-Bild
}

// === Alte Bilder löschen ===
$images = array_filter(scandir($archive_path), function($file) {
    return preg_match('/\.jpg$/i', $file);
});

sort($images); // Älteste zuerst

while (count($images) > $max_images) {
    $oldest = array_shift($images);
    @unlink("$archive_path/$oldest");
}

// === HTML-Ausgabe ===
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Webcam Archiv</title>
  <style>
    body { font-family: Arial, sans-serif; text-align: center; background: #f9f9f9; }
    img { border: 1px solid #ccc; margin-top: 20px; max-width: 90%; }
  </style>
</head>
<body>
  <h1>Webcam-Bild gespeichert</h1>
  <p>Das aktuelle Bild wurde erfolgreich archiviert:</p>
  <img src="<?= $archive_url . '/' . $filename ?>" width="<?= $image_width ?>" alt="Webcam-Bild">
  <p><button onclick="window.close()">Fenster schließen</button></p>
</body>
</html>
